<?php declare(strict_types = 1);

namespace Core\Model\Dao;

class SiteDomain
{
	/** @var string */
	public $domain;

	/** @var string */
	public $siteName;

	/** @var string */
	public $siteNameSeparator;

	/** @var string */
	protected $lang;

	/** @var int */
	public $isDefault = 0;

	public ?string $logo        = null;
	public ?string $inverseLogo = null;

	public ?string $defaultCountry = null;

	public ?string $defaultCurrency = null;

	public bool $isActive = true;

	public function __construct(public Site $site, string $domain, string $lang, int $isDefault = 0)
	{
		$this->domain    = $domain;
		$this->lang      = $lang;
		$this->isDefault = $isDefault;
		$site->addDomain($this, $isDefault);
	}

	public function getDomain(): string { return $this->domain; }

	public function setLang(string $lang): void { $this->lang = $lang; }

	public function getLang(): string { return $this->lang; }

	public function getDefaultCountry(): string
	{
		if ($this->lang === 'cs') {
			return 'CZ';
		} else if ($this->lang === 'sk') {
			return 'SK';
		}

		return $this->lang;
	}
}
