<?php declare(strict_types = 1);

namespace Core\Model\Dao;

use Core\Model\Entities\TSeo;
use Core\Model\Providers\ISiteMapImage;
use Core\Model\Providers\ISiteMapUrl;
use DateTimeInterface;

class SiteMapUrl implements ISiteMapUrl
{
	use TSeo;

	protected ?DateTimeInterface $modified = null;

	/** @var ISiteMapImage[] */
	protected array $images = [];

	public function getModified(): ?DateTimeInterface { return $this->modified; }

	public function setModified(DateTimeInterface $modified): void { $this->modified = $modified; }

	/**
	 * @return ISiteMapImage[]
	 */
	public function getImages(): array { return $this->images; }

	/**
	 * @param ISiteMapImage[] $images
	 */
	public function setImages(array $images): void
	{
		$this->images = [];

		foreach ($images as $img) {
			if ($img instanceof ISiteMapImage) {
				$this->images[] = $img;
			}
		}
	}

	public function addImage(ISiteMapImage $image): void
	{
		$this->images[] = $image;
	}

}
