<?php declare(strict_types = 1);

namespace Core\Model\Dao\Traits;

trait ExtraFields
{
	protected array $extraFields = [];

	public function addExtraField($key, $value): void
	{
		$this->extraFields[$key] = $value;
	}

	public function setExtraFields(array $array): void
	{
		$this->extraFields = $array;
	}

	public function getExtraFields(): array { return $this->extraFields; }

	public function getExtraField(string $key, $default = null) { return $this->extraFields[$key] ?? $default; }
}
