<?php declare(strict_types = 1);

namespace Core\Model\Entities;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'core__cookie_additional_service')]
#[ORM\UniqueConstraint(name: 'cookie_additional_service_ident__idx', columns: ['ident'])]
#[ORM\Entity]
class CookieAdditionalService
{
	use TId;

	#[ORM\Column(type: Types::STRING, nullable: false)]
	public string $ident;

	#[ORM\Column(type: Types::STRING, nullable: false)]
	public string $name;

	/**
	 * @var Collection<CookieAdditionalServiceInSite>
	 */
	#[ORM\OneToMany(mappedBy: 'cookieAdditionalService', targetEntity: CookieAdditionalServiceInSite::class, cascade: ['all'], orphanRemoval: true, indexBy: 'site')]
	public Collection $sites;

	public function __construct(string $ident, string $name)
	{
		$this->ident = $ident;
		$this->name  = $name;
		$this->sites = new ArrayCollection;
	}

	public function getSitesIdent(): array
	{
		return array_map(static fn(CookieAdditionalServiceInSite $s) => $s->site->getIdent(), $this->sites->toArray());
	}

	public function addSite(Site $site): void
	{
		$this->sites->add(new CookieAdditionalServiceInSite($this, $site));
	}

}
