<?php declare(strict_types = 1);

namespace Core\Model\Entities;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

#[ORM\Table(name: 'core__country')]
#[ORM\Entity]
class Country
{

	#[ORM\Id]
	#[ORM\Column(name: '`id`', type: Types::STRING, length: 255, nullable: false)]
	public string $id;

	#[ORM\Column(name: '`name`', type: Types::STRING, length: 255, nullable: true)]
	public ?string $name = null;

	#[ORM\Column(name: 'iso3166_1', type: Types::STRING, length: 3, nullable: false, options: ['default' => 'CZE'])]
	protected string $iso3166_1 = 'CZE';

	#[Gedmo\SortablePosition]
	#[ORM\Column(name: 'position', type: 'integer')]
	protected int $position;

	public function __construct(string $id, string $name, string $iso3166_1)
	{
		$this->id        = $id;
		$this->name      = $name;
		$this->iso3166_1 = $iso3166_1;
		$this->setPosition(-1);
	}

	public function getId(): string { return $this->id; }

	public function getName(): ?string { return $this->name; }

	public function setName(?string $name): self
	{
		$this->name = $name;

		return $this;
	}

	public function getPosition(): int { return $this->position; }

	public function setPosition(int $position): self
	{
		$this->position = $position;

		return $this;
	}

	public function getIso3166_1(): string { return strtoupper($this->iso3166_1); }

	public function setIso3166_1(string $iso3166_1): self
	{
		$this->iso3166_1 = $iso3166_1;

		return $this;
	}
}
