<?php declare(strict_types = 1);

namespace Core\Model\Entities;

use Doctrine\ORM\Proxy\Proxy;
use Doctrine\ORM\Query;
use Doctrine\ORM\Query as DoctrineQuery;
use Nettrine\ORM\EntityManagerDecorator as NettrineEM;

/**
 * @method EntityRepository getRepository($className)
 * @method Proxy|null getReference($className, $id)
 */
class EntityManagerDecorator extends NettrineEM
{
	public static bool $useDoctrineQuery = false;

	public function persist($object): self
	{
		parent::persist($object);

		return $this;
	}

	public function createQueryBuilder()
	{
		return new QueryBuilder($this);
	}

	/**
	 * @return Query|DoctrineQuery
	 */
	public function createQuery($dql = '')
	{
		if (self::$useDoctrineQuery) {
			$query = new DoctrineQuery($this);
		} else {
			$query = new Query($this);
		}

		if (!empty($dql)) {
			$query->setDQL($dql);
		}

		return $query;
	}
}
