<?php declare(strict_types = 1);

namespace Core\Model\Entities;

use Doctrine;
use Doctrine\ORM\AbstractQuery;
use Doctrine\ORM\Proxy\Proxy;

class EntityRepository extends Doctrine\ORM\EntityRepository
{
	/**
	 *
	 * @return array
	 */
	public function findPairs(
		string|array $criteria,
		?string      $value = null,
		string|array $orderBy = [],
		?string      $key = null,
	)
	{
		if (!is_array($criteria)) {
			$key      = is_array($orderBy) ? (string) $orderBy[0] : (string) $orderBy;
			$orderBy  = $value;
			$value    = $criteria;
			$criteria = [];
		}

		if (!is_array($orderBy)) {
			$key     = (string) $orderBy;
			$orderBy = [];
		}

		if (empty($key)) {
			$key = $this->getClassMetadata()->getSingleIdentifierFieldName();
		}

		/** @var QueryBuilder $qb */
		$qb = $this->createQueryBuilder('e');

		$qb->whereCriteria($criteria)
			->select(["e.$value", "e.$key"])
			->resetDQLPart('from')->from($this->getEntityName(), 'e', 'e.' . $key);
		$query = $qb->autoJoinOrderBy($orderBy)->getQuery();

		return array_map(static fn($row) => reset($row), $query->getResult(AbstractQuery::HYDRATE_ARRAY));
	}

	public function getReference(int|string $id): ?Proxy
	{
		/** @var Proxy|null $reference */
		$reference = $this->getEntityManager()->getReference($this->_entityName, $id);

		return $reference;
	}

	public function createQueryBuilder($alias, $indexBy = null)
	{
		return (new QueryBuilder($this->_em))
			->select($alias)
			->from($this->_entityName, $alias, $indexBy);
	}
}
