<?php declare(strict_types = 1);

namespace Core\Model\Entities;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'core__extra_field')]
#[ORM\Index(columns: ['section_name', 'key'], name: 'cef_base')]
#[ORM\Entity]
class ExtraField
{
	use TId;

	#[ORM\Column(name: 'section_name', type: Types::STRING, length: 255, nullable: false)]
	public ?string $sectionName = null;

	#[ORM\Column(name: 'section_key', type: Types::STRING, length: 255, nullable: false)]
	public ?string $sectionKey = null;

	#[ORM\Column(name: '`key`', type: Types::STRING, length: 255, nullable: false)]
	public string $key;

	#[ORM\Column(name: 'value', type: Types::TEXT, nullable: true)]
	public ?string $value = null;

	#[ORM\Column(name: 'lang', type: Types::STRING, length: 2, nullable: true)]
	public ?string $lang = null;

	public function __construct(string $key, ?string $value = null)
	{
		$this->key   = $key;
		$this->value = $value;
	}
}
