<?php declare(strict_types = 1);

namespace Core\Model\Entities;

use DateTimeInterface;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Nette\Utils\DateTime;

#[ORM\Table(name: 'core__redirect')]
#[ORM\Entity]
class Redirect
{
	use TId;

	public const CACHE_NAMESPACE = 'coreRedirect';

	#[ORM\Column(name: 'title', type: Types::STRING, length: 255, nullable: false)]
	public string $title;

	#[ORM\Column(name: '`from`', type: Types::STRING, length: 255, nullable: false)]
	public string $from;

	#[ORM\Column(name: '`to`', type: Types::STRING, length: 255, nullable: false)]
	public string $to;

	#[ORM\Column(name: 'is_locked', type: Types::SMALLINT, nullable: false, options: ['default' => 0])]
	public int $isLocked = 0;

	#[ORM\Column(name: '`package`', type: Types::STRING, length: 255, nullable: true)]
	public ?string $package = null;

	#[ORM\Column(name: 'relation_key', type: Types::STRING, length: 255, nullable: true)]
	public ?string $relationKey = null;

	#[ORM\Column(name: 'relation_value', type: Types::STRING, length: 255, nullable: true)]
	public ?string $relationValue = null;

	#[ORM\Column(name: 'redirect_code', type: Types::STRING, length: 255, nullable: false, options: ['default' => 301])]
	public string $redirectCode = '301';

	#[ORM\Column(name: 'is_published', type: Types::SMALLINT, nullable: false, options: ['default' => 1])]
	public int $isPublished = 1;

	#[ORM\Column(name: 'views', type: Types::INTEGER, nullable: false, options: ['default' => 0])]
	public int $views = 0;

	/** @var array */
	#[ORM\Column(name: 'params', type: Types::ARRAY, nullable: true)]
	protected $params;

	#[ORM\Column(name: 'site_ident', type: Types::STRING, length: 255, nullable: true)]
	public ?string $siteIdent = null;

	#[ORM\Column(name: 'lang', type: Types::STRING, length: 5, nullable: true)]
	public ?string $lang = null;

	#[ORM\Column(name: 'last_check', type: Types::DATETIME_MUTABLE, nullable: true)]
	public ?DateTimeInterface $lastCheck = null;

	#[ORM\Column(name: 'last_status', type: Types::STRING, length: 255, nullable: true)]
	public ?string $lastStatus = null;

	public function __construct(string $title, string $from, string $to)
	{
		$this->title        = $title;
		$this->from         = $from;
		$this->to           = $to;
		$this->isLocked     = 0;
		$this->redirectCode = '301';
		$this->isPublished  = 1;
		$this->params       = [];
		$this->views        = 0;
	}

	public function getParams(): array { return $this->params ?: []; }

	/**
	 * @return mixed|null
	 */
	public function getParam(string $key) { return $this->params[$key] ?? null; }

	/**
	 * @param mixed $value
	 */
	public function setParam(string $key, $value): void
	{
		if ($value) {
			$this->params[$key] = $value;
		} else {
			unset($this->params[$key]);
		}
	}

	public function updateCheck(string $status): void
	{
		$this->lastCheck  = new DateTime();
		$this->lastStatus = $status;
	}
}
