<?php declare(strict_types = 1);

namespace Core\Model\Entities;

use DateTimeImmutable;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Nette\Utils\Json;

#[ORM\Table(name: 'core__setting')]
#[ORM\Entity]
class Setting
{

	#[ORM\Id]
	#[ORM\Column(name: '`key`', type: Types::STRING, length: 255, nullable: false)]
	public string $key;

	#[ORM\Column(name: '`value`', type: Types::TEXT, nullable: true)]
	public ?string $value = null;

	/**
	 * @param mixed $value
	 */
	public function __construct(string $key, $value)
	{
		$this->key = $key;
		$this->setValue($value);
	}

	/**
	 * @param mixed $value
	 */
	public function setValue($value): void
	{
		if (is_array($value)) {
			$value = Json::encode($value);
		}

		if ($value instanceof DateTimeImmutable) {
			$value = $value->format('d.m.Y H:i');
		}

		$this->value = (string) $value;
	}
}
