<?php declare(strict_types = 1);

namespace Core\Model\Entities;

use Core\Model\Helpers\Strings;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'core__site')]
#[ORM\Entity]
class Site
{
	#[ORM\Id]
	#[ORM\Column(name: 'ident', type: Types::STRING, length: 255, nullable: false)]
	protected string $ident;

	/**
	 * @var Collection<string, SiteText>
	 */
	#[ORM\OneToMany(mappedBy: 'site', targetEntity: SiteText::class, indexBy: 'lang')]
	public Collection $texts;

	#[ORM\Column(name: 'site_name_separator', type: Types::STRING, length: 255, nullable: true)]
	public ?string $siteNameSeparator = null;

	#[ORM\Column(name: 'email', type: Types::STRING, length: 255, nullable: true)]
	public ?string $email = null;

	#[ORM\Column(name: 'is_visible', type: Types::SMALLINT, nullable: false, options: ['unsigned' => true,
	                                                                                   'default'  => 1])]
	public int $isVisible = 1;

	public function __construct(string $ident)
	{
		$this->setIdent($ident);
		$this->texts = new ArrayCollection;
	}

	public function setIdent(string $ident): self
	{
		$this->ident = Strings::webalize($ident);

		return $this;
	}

	public function getIdent(): string { return $this->ident; }

	public function setTexts(array $texts): self
	{
		$this->texts = new ArrayCollection($texts);

		return $this;
	}
}
