<?php declare(strict_types = 1);

namespace Core\Model\Entities;

use Contributte\Translation\Translator;
use Doctrine;
use Doctrine\ORM\Mapping as ORM;
use Nette\SmartObject;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class TranslateListener implements EventSubscriberInterface
{
	use SmartObject;

	public function __construct(
		protected Translator $translator,
	)
	{
	}

	public static function getSubscribedEvents(): array
	{
		return [];
	}

	#[ORM\PostLoad]
	#[ORM\PostPersist]
	public function postLoadHandler(object $entity): void
	{
		if (property_exists($entity, 'locale')) {
			$entity->locale = $this->translator->getLocale();
		}
	}
}
