<?php declare(strict_types = 1);

namespace Core\Model\Event;

use Core\Model\UI\Form\BaseForm;
use Nette\Application\UI\Control;
use Nette\Bridges\ApplicationLatte\Template;
use Symfony\Contracts\EventDispatcher\Event;

class CreateFormEvent extends Event
{
	public Template $template;
	public ?Control $control = null;
	public array    $data    = [];

	public function __construct(public BaseForm $form, ?Template $template)
	{
		if ($template) {
			$this->template = &$template;
		}
	}
}
