<?php declare(strict_types = 1);

namespace Core\Model\Event;

use Nette\ComponentModel\IContainer;
use Nette\Utils\Html;
use Symfony\Contracts\EventDispatcher\Event;

class PartRenderEvent extends Event
{
	protected array $data = [];

	public function __construct(protected string $key, protected IContainer $control)
	{
	}

	public function getKey(): string { return $this->key; }

	public function getControl(): IContainer { return $this->control; }

	public function getData(): array { return $this->data; }

	protected function addData(string $type, string|array|Html $value): void
	{
		$this->data[] = [
			'type' => $type,
			'data' => $value,
		];
	}

	public function addRenderHtml(Html $html): void { $this->addData('html', $html); }

	public function addRenderFile(string $file): void { $this->addData('file', $file); }

	public function addRenderTemplate(string $file, array $params, array $data = []): void
	{
		$this->addData('template', [
			'file'   => $file,
			'params' => $params,
			'data'   => $data,
		]);
	}
}
