<?php declare(strict_types = 1);

namespace Core\Model\FilesManager;

use Core\Model\SystemConfig;
use elFinder;
use elFinderConnector;
use Nette\Http\Session;
use Nette\Http\SessionSection;

class FilesManager
{
	public ?array                $overrideRoots = null;
	protected array              $params        = [];
	protected SessionSection     $sessionSection;
	protected ?elFinderConnector $connector     = null;

	public function __construct(
		protected array         $options,
		Session                 $session,
		protected ElFinderImage $elFinderImage,
	)
	{
		$this->sessionSection = $session->getSection('filemanager');

		$this->options['bind']['rm rename'] = $elFinderImage->removeThumbs(...);

		if (SystemConfig::load('images.autoResize.allow')) {
			$this->options['bind']['upload.presave'] = [
				'Plugin.AutoResize.onUpLoadPreSave',
			];
			$this->options['plugin']['AutoResize']   = [
				'enable'       => true,
				'maxWidth'     => (int) SystemConfig::load('images.autoResize.w'),
				'maxHeight'    => (int) SystemConfig::load('images.autoResize.h'),
				'quality'      => 85,
				'preserveExif' => false,
				'forceEffect'  => false,
				'targetType'   => IMG_GIF | IMG_JPG | IMG_PNG | IMG_WBMP,
				'offDropWith'  => null,
			];
		}
	}

	public function getConnector(): elFinderConnector
	{
		if ($this->overrideRoots) {
			$this->options['roots'] = $this->overrideRoots;
		} else {
			$roots = $this->sessionSection->roots;
			if (isset($this->params['rootsSession']) && $roots[$this->params['rootsSession']]) {
				foreach ($roots[$this->params['rootsSession']] as $key => $root) {
					$this->options['roots'][$key] = $root;
				}
			}
		}

		if ($this->connector === null) {
			$this->connector = new elFinderConnector(new elFinder($this->options));
		}

		return $this->connector;
	}

	public function run(array $params): void
	{
		$this->params = $params;
		$this->getConnector()->run();
	}
}
