<?php declare(strict_types = 1);

namespace Core\Model\Helpers;

class CurlHelper
{
	public static function getArrayHeader(string $response): array
	{
		$headers = [];

		$headerText = substr($response, 0, strpos($response, "\r\n\r\n") ?: null);

		foreach (explode("\r\n", $headerText) as $i => $line) {
			if ($i === 0) {
				$headers['http_code'] = $line;
			} else {
				[$key, $value] = explode(': ', $line);

				$headers[$key] = $value;
			}
		}

		return $headers;
	}
}
