<?php declare(strict_types = 1);

namespace Core\Model\Helpers;

use Core\Model\Entities\ExtraField;
use Core\Model\Helpers\Traits\TExtraField;
use InvalidArgumentException;

abstract class EntityHelpers
{

	/**
	 * @param TExtraField|object $entity
	 * @param mixed|null         $value
	 */
	public static function setExtraField($entity, string $key, $value, ?string $lang = null): ExtraField
	{
		if (!method_exists($entity, 'getExtraFieldsByKey') || !method_exists($entity, 'fillExtraField')) {
			throw new InvalidArgumentException($entity::class . ' missing TExtraField trait');
		}

		$ef = $entity->getExtraFieldsByKey();

		/** @var ExtraField|null $result */
		$result = $ef[$key] ?? null;

		if ($lang) {
			$result = $result[$lang] ?? null;
		}

		if (!$result) {
			$result       = new ExtraField($key, $value);
			$result->lang = $lang;
			$entity->fillExtraField($result);
		}

		$result->value = $value;

		return $result;
	}
}
