<?php declare(strict_types = 1);

namespace Core\Model\Helpers\Traits;

use Core\Model\Entities\EntityManagerDecorator;
use Core\Model\Entities\EntityRepository;
use Doctrine\DBAL\DBALException;
use Exception;

/**
 * Trait TPosition
 * @package Core\Model\Helpers\Traits
 *
 * @property EntityManagerDecorator $em
 * @method EntityRepository getEr()
 */
trait TPosition
{
	/**
	 * @param int $id
	 * @param int $position
	 *
	 * @return bool
	 * @throws Exception
	 */
	public function setPosition($id, $position)
	{
		if ($item = $this->getReference($id)) {
			$item->setPosition((int) $position);
			$this->em->persist($item);
			$this->em->flush();

			return true;
		}

		return false;
	}

	/**
	 * @return bool
	 * @throws DBALException
	 */
	public function repairPositions()
	{
		$items = $this->getEr()->createQueryBuilder('e')->select('e.id, e.position')
			->orderBy('e.position')->addOrderBy('e.id')->getQuery()->getArrayResult();

		$i         = 0;
		$tableName = $this->em->getClassMetadata($this->entityClass)->getTableName();
		$conn      = $this->em->getConnection();
		$conn->beginTransaction();
		try {
			foreach ($items as $item) {
				$conn->update($tableName, [
					'position' => $i,
				], [
					'id' => $item['id'],
				]);
				$i++;
			}
		} catch (Exception) {
			if ($conn->isTransactionActive())
				$conn->rollBack();
		}

		return true;
	}
}
