<?php declare(strict_types = 1);

namespace Core\Model\Helpers\Traits;

use Exception;

trait TPublish
{
	public function invertPublish(int $id): bool
	{
		if ($item = $this->get($id)) {
			$item->isPublished = !$item->isPublishes;
			$this->em->persist($item)->flush;

			return true;
		}

		return false;
	}

	public function setPublish($id, $state): bool
	{
		if ($item = $this->get($id)) {
			$item->isPublished = (int) $state;
			$this->em->persist($item)->flush();

			return true;
		}

		return false;
	}

	public function setPublishMultiple(array $ids, int $state): bool
	{
		try {
			foreach ($ids as $id) {
				$e              = $this->getReference($id);
				$e->isPublished = $state;
				$this->em->persist($e);
			}

			$this->em->flush();

			return true;
		} catch (Exception) {
		}

		return false;
	}
}
