<?php declare(strict_types = 1);

namespace Core\Model\Http;

use Core\Model\Application\AppState;
use Core\Model\SystemConfig;
use Nette\Application\Response;
use Nette\Application\UI\Template;
use Nette\Http\IRequest;
use Nette\Http\IResponse;
use Nette\SmartObject;

class TextResponse implements Response
{
	use SmartObject;

	public function __construct(protected mixed $source)
	{
	}

	/** @return mixed */
	public function getSource() { return $this->source; }

	public function send(IRequest $httpRequest, IResponse $httpResponse): void
	{
		if ($this->source instanceof Template) {
			if (!$httpRequest->isAjax() && method_exists($this->source, 'renderToString')
				&& SystemConfig::load('cookieBar.enable', false) && !SystemConfig::load('cookieBar.fakeMode', false)
				&& !in_array('youtube', SystemConfig::load('cookieBar.partialFakeMode', []))
				&& !in_array('youtube', AppState::getState('allowCookieServices', []))) {

				$output = $this->source->renderToString();
				$output = preg_replace('/youtube\.com\/(v|embed)\//s', 'youtube-nocookie.com/$1/', (string) $output);

				echo $output;
			} else {
				$this->source->render();
			}
		} else {
			echo $this->source;
		}
	}

}
