<?php declare(strict_types = 1);

namespace Core\Model\Images;

use Nette;
use Stringable;

/**
 *
 * @property-read string $file
 * @property-read Size   $size
 */
class Image implements Stringable
{
	use Nette\SmartObject;

	protected readonly Size $size;

	/**
	 * @param string $file
	 */
	public function __construct(private $file)
	{
		$this->size = Size::fromFile($file);
	}

	/**
	 * @return bool
	 */
	public function exists()
	{
		return file_exists($this->file);
	}

	public function getFile(): ?string { return $this->file; }

	/**
	 * @return string
	 */
	public function getBasename()
	{
		return basename($this->getFile());
	}

	/**
	 * @return Size
	 */
	public function getSize()
	{
		return $this->size;
	}

	/**
	 * @return string
	 */
	public function __toString(): string
	{
		return $this->getBasename();
	}
}
