<?php declare(strict_types = 1);

namespace Core\Model\Lang;

use Contributte\Translation\Translator;

class Langs
{
	protected ?Translator $translator = null;
	protected array       $langs      = [];

	public function setTranslator(
		Translator $translator,
	): void
	{
		$this->translator = $translator;

		$this->langs['default'] = new Lang(
			$translator->translate('lang.title'),
			$translator->translate('lang.shortTitle'),
			$translator->translate('lang.tag'),
			$translator->translate('lang.fullTag')
		);

		foreach ($translator->getLocalesWhitelist() as $locale) {
			$lang                         = new Lang(
				$translator->trans('title', [], 'lang', $locale),
				$translator->trans('shortTitle', [], 'lang', $locale),
				$translator->trans('tag', [], 'lang', $locale),
				$translator->trans('fullTag', [], 'lang', $locale)
			);
			$this->langs[$lang->getTag()] = $lang;
		}
	}

	public function getLang(string $locale = 'default'): Lang
	{
		return $this->langs[$locale] ?? $this->langs['default'];
	}

	/**
	 * @return Lang[]
	 */
	public function getLangs(bool $withDefault = true): array
	{
		$tmp = $this->langs;

		if (!$withDefault) {
			unset($tmp['default']);
		}

		return $tmp;
	}

	public function setDefault(string $key): self
	{
		$this->langs['default'] = $this->getLang($key);

		return $this;
	}

	public function getOptionsForSelect(): array
	{
		$list = [];

		foreach ($this->getLangs(false) as $id => $lang) {
			$list[$id] = $lang->getTitle();
		}

		return $list;
	}
}
