<?php declare(strict_types = 1);

namespace Model\Navigation;

use Core\Components\Navigation\DaoNavigationItem;
use Core\Model\Navigation\BaseNavigation;
use Core\Model\UI\Form\BaseContainer;
use Core\Model\UI\Form\BaseForm;
use Navigations\Model\Providers\INavigationItem;
use Nette\Utils\ArrayHash;

class NetteLink extends BaseNavigation implements INavigationItem
{
	protected $title = 'netteLink';

	public function __construct()
	{
	}

	/**
	 * @return BaseContainer
	 */
	public function getFormContainer(BaseForm $baseForm)
	{
		$container = new BaseContainer();

		$container->addText('link', 'default.navigationForm.link')->setRequired();

		return $container;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{
	}

	/*******************************************************************************************************************
	 * ===========================  Route
	 */

	public function presenterActionCheck($presenter, $action)
	{
		return false;
	}

	public function routerIn($params, $urlParams = [])
	{
		return ['systemLink' => $params->link];
	}

	public function routerOut(DaoNavigationItem $navigation, &$urlParams): ?string
	{
		return null;
	}
}
