<?php declare(strict_types = 1);

namespace Core\Model\Router;

use Closure;
use Nette;
use function str_contains;
use function str_starts_with;

class Route extends Nette\Application\Routers\Route
{
	/**
	 * @param array|string|Closure $metadata
	 */
	public function __construct(string $mask, $metadata = [], int $flags = 0, ?string $locale = null)
	{
		if ($locale && !str_starts_with($mask, '//') && !str_starts_with($mask, 'http')) {
			$mask = '/[<locale=' . $locale . ' [a-z]{2}>/]' . ltrim($mask, '/');
		}

		parent::__construct($mask, $metadata, $flags);
	}

	public function constructUrl(array $params, Nette\Http\UrlScript $refUrl): ?string
	{
		if (isset($params['presenter']) && str_contains((string) $params['presenter'], 'Override')) {
			$metadata = $this->getMetadata();
			if (isset($metadata['presenter']['value']) && $metadata['presenter']['value'] !== $params['presenter']) {
				$params['presenter'] = str_replace('Override', '', (string) $params['presenter']);
			}
		}

		return parent::constructUrl($params, $refUrl);
	}

}
