<?php declare(strict_types = 1);

namespace Core\Model\Router;

use Closure;
use Contributte\Translation\Translator;
use Core\Model\Helpers\Arrays;
use Core\Model\Sites;

class RouteHelper
{
	public static ?string $validatedLang = null;

	public function __construct(protected array $translation, protected Translator $translator, protected Sites $sites)
	{
	}

	public function createRoute(
		string               $mask,
		array|string|Closure $metadata = [],
		int                  $flags = 0,
		?string              $locale = null,
	): Route
	{
		$domainLangs = array_keys($this->sites->getCurrentSite()->getDomains());
		$langs       = array_intersect($this->translation['whitelist'], $domainLangs);

		if (self::$validatedLang) {
			$locale = self::$validatedLang;
		}

		if (!$locale || ($langs && !Arrays::contains($langs, $locale))) {
			$locale = $this->translation['default'];
		}

		$this->translator->setLocale($locale);

		return new Route($mask, $metadata, $flags, count($langs) <= 1 ? null : $locale);
	}

	public function createAdminRoute(
		string               $mask,
		array|string|Closure $metadata = [],
		int                  $flags = 0,
		?string              $locale = null,
	): RouteAdmin
	{
		$langs = $this->translation['whitelist'];

		if (!$locale || !Arrays::contains($langs, $locale)) {
			$locale = $this->translation['default'];
		}

		$this->translator->setLocale($locale);

		return new RouteAdmin($mask, $metadata, $flags, $locale);
	}
}
