<?php declare(strict_types = 1);

namespace Core\Model\TemplateReader\Entity;

use Doctrine\ORM\Mapping as ORM;
use Nette\Utils\ArrayHash;
use Nette\Utils\Json;

trait TTemplate
{
	/**
	 * @var string
	 */
	#[ORM\Column(name: 'template', type: 'string', length: 255, nullable: false)]
	public $template;

	/**
	 * @var string|array|ArrayHash
	 */
	#[ORM\Column(name: 'texts', type: 'array')]
	protected $texts;

	/**
	 * @return array
	 */
	public function getTexts()
	{
		return is_array($this->texts) ? $this->texts : [];
	}

	/**
	 * @param string $text
	 *
	 * @return string
	 */
	public function getText($text)
	{
		return $this->texts[$text] ?? '';
	}

	/**
	 * @param $texts
	 */
	public function setTexts($texts)
	{
		$this->texts = is_array($texts) ? $texts : Json::decode($texts, Json::FORCE_ARRAY);
	}
}
