<?php declare(strict_types = 1);

namespace Core\Model\TemplateReader\Providers;

use Core\Model\TemplateReader\TemplateTextTypesCollection;
use Nette\Utils\Json;

class TemplateText
{
	public function __construct(protected TemplateTextTypesCollection $templateTextTypes)
	{
	}

	/**
	 * @param mixed|null $value
	 */
	public function render(string $type, $value = null, string|array $params = []): string|array|null|int
	{
		$item = $this->templateTextTypes->getItemByType($type);

		if ($item) {
			$item->setDefault($value);

			if (is_string($params)) {
				$params = Json::decode($params, Json::FORCE_ARRAY);
			}

			if (isset($params['title'])) {
				$item->setTitle($params['title']);
			}

			if (isset($params['name'])) {
				$item->setName($params['name']);
			}

			return $item->render($params);
		}

		return '';
	}
}
