<?php declare(strict_types = 1);

namespace Core\Model\UI;

use Core\Model\Event\ControlEvent;
use Core\Model\UI\Traits\TPresenterComponentPack;

abstract class ErrorPresenter extends AbstractPresenter
{
	use TPresenterComponentPack;

	protected function startup()
	{
		$this->eventDispatcher->dispatch(new ControlEvent($this), self::class . '::startup');
		parent::startup();
	}

	public function beforeRender()
	{
		$this->eventDispatcher->dispatch(new ControlEvent($this), self::class . '::beforeRender');
		parent::beforeRender();
	}
}
