<?php declare(strict_types = 1);

namespace Core\Model\UI\Form;

use Core\Model\UI\Form\Traits\BaseContainerTrait;
use Core\Model\UI\Form\Traits\BootstrapContainerTrait;
use Nette\Forms\Container;

/**
 * @method BaseForm getForm(bool $throw = true)
 */
class BaseContainer extends Container
{
	use BootstrapContainerTrait;
	use BaseContainerTrait;

	protected array $customData = [];

	public function addCustomData(string $key, mixed $value): self
	{
		$this->customData[$key] = $value;

		return $this;
	}

	/**
	 * @return mixed|null
	 */
	public function getCustomData(string $key) { return $this->customData[$key] ?? null; }
}
