<?php declare(strict_types = 1);

namespace Core\Model\UI\Form\Controls;

use Core\Model\UI\Form\BaseForm;
use Core\Model\UI\Form\Traits\BootstrapButtonTrait;
use Core\Model\UI\Form\Traits\TInputExtend;
use Nette\Forms\Controls\Button;
use Nette\HtmlStringable;
use Nette\Utils\Html;

/**
 * @method BaseForm getForm(bool $throw = true)
 * @property string $btnClass
 */
class ButtonInput extends Button
{
	use BootstrapButtonTrait;
	use TInputExtend;

	/**
	 * @param null|string|Html|object $content
	 */
	public function __construct($content = null)
	{
		parent::__construct($content);
	}

	/**
	 * @param null|string|Html $content
	 */
	public function getControl($content = null): Html
	{
		$btn = Html::el('button', [
			'type' => 'button',
		]);

		if ($content) {
			$btn->setHtml($content);
		} else if (is_string($this->caption) || $this->caption instanceof HtmlStringable) {
			$btn->setHtml($this->caption);
		}

		$this->addBtnClass($btn);

		return $btn;
	}
}
