<?php declare(strict_types = 1);

namespace Core\Model\UI\Form\Controls;

use Core\Model\UI\Form\BaseContainer;
use Iterator;
use Nette\Forms\Controls\BaseControl;

class SaveCancelControl extends BaseContainer
{
	protected bool $floating     = false;
	public bool    $showOnlySave = false;

	public function __construct(
		?string $saveCaption = null,
		?string $saveAndCloseCaption = null,
		?string $cancelCaption = null,
	)
	{
		$this->addSubmit('save', $saveCaption ?: 'default.save')
			->getControlPrototype()->addHtml('<i class="fa fa-save"></i>');
		$this->addSubmit('saveAndClose', $saveAndCloseCaption ?: 'default.saveAndClose')
			->getControlPrototype()->addHtml('<i class="fa fa-check"></i>');
		$this->addCancel('cancel', $cancelCaption ?: 'default.cancel')
			->setHtmlAttribute('type', 'button')
			->setHtmlAttribute('onclick', 'window.history.go(-1);')
			->setValidationScope([])
			->getControlPrototype()->addHtml('<i class="fa fa-times"></i>');
	}

	public function getControls(): Iterator
	{
		if ($this->showOnlySave) {
			$this->removeComponent($this->getComponent('saveAndClose'));
			$this->removeComponent($this->getComponent('cancel'));
		}

		if ($this->getForm()->onCancel) {
			/** @var BaseControl $cancel */
			$cancel = $this['cancel'];
			$cancel->setHtmlAttribute('type', 'submit');
			$cancel->setHtmlAttribute('onclick', null);
		}

		return parent::getControls();
	}

	public function setFloating(bool $value = true): void
	{
		$this->floating = $value;
	}

	public function isFloating(): bool
	{
		return $this->floating;
	}

	public function closeModalOnCancel(): void
	{
		/** @var BaseControl $cancel */
		$cancel = $this['cancel'];
		$cancel->setHtmlAttribute('onclick', 'closeModal("' . $cancel->getHtmlId() . '");');
	}
}
