<?php declare(strict_types = 1);

namespace Core\Model\UI\Form\Controls;

use Nette\Forms\Controls\Button;
use Nette\Http\Url;
use Nette\Utils\Html;

class Window extends Button
{
	public function __construct(protected string $url, $caption = null)
	{
		parent::__construct($caption);
	}

	public function getControl($content = null): Html
	{
		$modalId = $this->getHtmlId() . '-windowModal';
		$url     = new Url($this->url);
		$url->setQueryParameter('fullScreen', 1);

		$btn = parent::getControl();
		$btn->setAttribute('class', 'btn btn-primary w-auto');
		$btn->setAttribute('data-toggle', 'modal');
		$btn->setAttribute('data-target', '#' . $modalId);

		$wrap = Html::el();
		$wrap->addHtml($btn);

		$latte = file_get_contents(__DIR__ . '/Window.latte');
		if ($latte) {
			$latte = str_replace(['{$link}', '{$id}'], [(string) $url, $modalId], $latte);
			$wrap->addHtml($latte);
		}

		return $wrap;
	}
}
