<?php declare(strict_types = 1);

namespace Core\Model;

class WebColors
{
	public function __construct(protected Settings $settings)
	{
	}

	public function clearCache(): void
	{
		$this->settings->clearCache();
	}

	public function getColors(string $siteIdent = ''): array
	{
		$siteIdent = $siteIdent === '' ? $siteIdent : $siteIdent . '_';

		return $this->settings->getPrefixed($siteIdent . 'webColors') ?: [];
	}
}
