/**
 * SVG icons
 */
let loadedIcons    = [];
let startedRequest = [];

const initDataLinkOnChange = () => {
	document.querySelectorAll('[data-link-on-change]:not(.init)').forEach(el => {
		el.classList.add('init');
		el.addEventListener('change', e => {
			e.preventDefault();

			const link = el.dataset.linkOnChange.replace('__val__', el.value);

			global.naja.makeRequest('post', link, {}, {
				history: false,
			});
		});
	});
};

const loadSvgIcons = () => {
	document.querySelectorAll('[data-svg-icon]').forEach(el => {
		let XMLrequest = new XMLHttpRequest();
		XMLrequest.open("GET", '/assets/front/img/icons/' + el.dataset.svgIcon + '.svg', true); // URL of the SVG file on server
		XMLrequest.send(null);
		el.removeAttribute('data-svg-icon');
		XMLrequest.onload = function (e) {
			el.removeAttribute('data-svg-icon');
			if (el.dataset.replace !== undefined)
				el.outerHTML = XMLrequest.responseText;
			else
				el.insertAdjacentHTML('afterbegin', XMLrequest.responseText);
		}
	});
	document.querySelectorAll('[data-svg-icon-pshk]').forEach(el => {
		const iconName = el.dataset.svgIconPshk;
		if (loadedIcons[iconName]) {
			el.removeAttribute('data-svg-icon-pshk');

			if (el.dataset.replace !== undefined)
				el.outerHTML = loadedIcons[iconName];
			else
				el.insertAdjacentHTML('afterbegin', loadedIcons[iconName]);
		} else {
			if (startedRequest[iconName])
				return;

			startedRequest[iconName] = true;

			let XMLrequest = new XMLHttpRequest();
			XMLrequest.open("GET", 'https://assets.pshk.cz/icons/' + iconName + '.svg', true); // URL of the SVG file on server
			XMLrequest.send(null);
			XMLrequest.onload = function (e) {
				document.querySelectorAll('[data-svg-icon-pshk="' + iconName + '"]').forEach(iconEl => {
					iconEl.removeAttribute('data-svg-icon-pshk');
					loadedIcons[iconName] = XMLrequest.responseText;
					if (iconEl.dataset.replace !== undefined)
						iconEl.outerHTML = XMLrequest.responseText;
					else
						iconEl.insertAdjacentHTML('afterbegin', XMLrequest.responseText);
				});
			}
		}
	});
	document.querySelectorAll('[data-svg-img]').forEach(el => {
		let XMLrequest = new XMLHttpRequest();
		XMLrequest.open("GET", el.dataset.svgImg, true); // URL of the SVG file on server
		XMLrequest.send(null);
		el.removeAttribute('data-svg-icon');
		XMLrequest.onload = function (e) {
			el.removeAttribute('data-svg-img');
			if (el.dataset.replace !== undefined)
				el.outerHTML = XMLrequest.responseText;
			else
				el.insertAdjacentHTML('afterbegin', XMLrequest.responseText);
		}
	});
}

loadSvgIcons();
initDataLinkOnChange();

document.addEventListener('loadSvgIcons', e => {
	loadSvgIcons();
});

global.naja.addEventListener('complete', e => {
	loadSvgIcons();
	initDataLinkOnChange();
});

/**
 * Last clicked element
 */
global.naja.addEventListener('start', e => {
	global.lastClicked = document.activeElement;
});

/**
 * Ajax content replace
 */
global.naja.addEventListener('complete', e => {
	// Automatická změna titulku pokud proběhne ajax a je potřeba ho změnit
	if (e.response && e.response.pageTitle)
		document.title = e.response.pageTitle;

	// Aktualizace html elementu podle response
	if (e.response && e.response.ajaxPlaceholders) {
		for (let [key, value] of Object.entries(e.response.ajaxPlaceholders)) {
			// Vlozeni hodnoty
			document.querySelectorAll('[data-ajax-placeholder="' + key + '"').forEach(el => {
				el.innerHTML = value;
			});

			// Zobrazeni prvku
			document.querySelectorAll('[data-ajax-placeholder-show-if="' + key + '"').forEach(el => {
				if (value) {
					el.style.display = 'block';
				} else {
					el.style.display = 'none';
				}
			});
		}
	}
});

document.addEventListener('click', e => {
	if (e.target.dataset.najaRequest !== undefined) {
		e.preventDefault();
		const url  = new URL(e.target.href);
		let config = {};

		if (e.target.dataset.najaRequest) {
			config = JSON.parse(e.target.dataset.najaRequest);

			if (config.pageOutput) {
				url.searchParams.set('pageOutput', config.pageOutput);
			}
		}

		global.naja.makeRequest('get', url.toString(), {
			                        requestKey: config.requestKey ?? null,
		                        }, {
			                        history: false,
		                        }
		);

		e.preventDefault();
		return false;
	}
})
