<?php declare(strict_types = 1);

/**
 * [--composer-update] misto composer install provede update
 * [--no-acl] nebude aktualizovat opraveni
 * [--no-composer] neprovede zadny composer prikaz
 * [--no-npm] neprovede zadny npm prikaz
 * [--only-clear-cache] pouze promaze cache
 */

use Nette\Utils\FileSystem;
use Nette\Utils\Finder;
use Nette\Utils\Json;
use Nette\Utils\Strings;

require __DIR__ . '/../../autoload.php';

if (Strings::contains(getcwd(), 'pshkcms') && Strings::contains(getcwd(), 'core')) {
	$root = '../../../';
	$cdRoot = 'cd ' . $root . ' &&';
} else {
	$root = '';
	$cdRoot = '';
}

echo '=================== CLEAR TEMP AND LOG ===================' . PHP_EOL;
foreach (['temp', 'log'] as $dir) {
	foreach (Finder::findDirectories('*')->in($root . $dir) as $file) {
		FileSystem::delete($file->getPathname());
	}
	foreach (Finder::findFiles('*')->in($root . $dir) as $file) {
		FileSystem::delete($file->getPathname());
	}
}

if (in_array('--only-clear-cache', $argv)) {
	return;
}

if (!in_array('--no-composer', $argv)) {
	if (in_array('--composer-update', $argv)) {
		echo '=================== COMPOSER UPDATE ===================' . PHP_EOL;
		shell_exec(sprintf('%s composer update', $cdRoot));
	} else {
		echo '=================== COMPOSER INSTALL ===================' . PHP_EOL;
		shell_exec(sprintf('%s composer install', $cdRoot));
	}
}

$v = $root === '' ? 'vendor' : ($root . 'vendor');
if (file_exists($v . '/brainmaestro/composer-git-hooks')) {
	echo '=================== UPDATE BINDING GIT HOOKS ===================' . PHP_EOL;
	foreach (Finder::findFiles('composer.json')->from($v . '/pshkcms') as $composerFile) {
		try {
			$composer = Json::decode(file_get_contents($composerFile->getPathname()), Json::FORCE_ARRAY);
			if (isset($composer['extra']['hooks'])) {
				echo 'PACKAGE ' . $composerFile->getPath() . PHP_EOL;
				echo shell_exec(sprintf('cd %s && php ../../bin/cghooks update', $composerFile->getPath()));
			}
		} catch (Exception $exception) {
		}
	}
}

if (!in_array('--no-acl', $argv)) {
	echo '=================== UPDATE ACL ===================' . PHP_EOL;
	echo shell_exec(sprintf('%s php bin/console users:update-acl', $cdRoot));
}

echo '=================== MIGRATIONS ===================' . PHP_EOL;
echo shell_exec(sprintf('%s php bin/console migrations:migrate --no-interaction', $cdRoot));

if (!in_array('--no-npm', $argv)) {
	echo '=================== NPM INSTALL ===================' . PHP_EOL;
	echo shell_exec(sprintf('%s npm install', $cdRoot));
	echo '=================== NPM RUN ADMIN-INSTALL ===================' . PHP_EOL;
	echo shell_exec(sprintf('%s npm run admin-install', $cdRoot));
	exit;
}