<?php declare(strict_types = 1);

namespace Core\AdminModule\Components\Country;

use Core\Model\UI\Form\Controls\TextInput;
use Nette\Caching\Cache;
use Nette\Utils\ArrayHash;
use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use Core\Model\Countries;
use Core\Model\Entities\Country;

class CountryForm extends BaseControl
{
	protected ?Country $country = null;

	protected Countries $countriesService;

	public function __construct(
		Countries $countries
	)
	{
		$this->countriesService = $countries;
	}

	public function render(): void
	{
		$this->template->render($this->getTemplateFile());
	}

	/*******************************************************************************************************************
	 * ======================== COMPONENTS
	 */

	protected function createComponentForm(): BaseForm
	{
		$form = $this->createForm();
		$form->setAjax();

		$form->addText('name', 'default.name2')
			->setRequired()
			->setMaxLength(255);
		$form->addText('id', 'admin.countryForm.idCountry')
			->setMaxLength(2);
		$form->addText('iso3166_1', 'admin.countryForm.iso3166_1')
			->setMaxLength(3)
			->setRequired();
		$form->addSaveCancelControl('saveControl');

		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values): bool
	{
		$this->em->beginTransaction();
		try {
			if ($this->country) {
				$country = $this->country;
			} else {
				$country = new Country($values->id, $values->name, $values->iso3166_1);
			}

			$country->setName($values->name);
			$country->setIso3166_1($values->iso3166_1);

			$this->em->persist($country)->flush();

			$form->addCustomData('countryId', $country->getId());

			$this->presenter->flashMessageSuccess('default.saved');
			$this->presenter->redrawControl('flashes');

			$this->em->commit();

			$cache = new Cache($this->cacheStorage, Countries::CACHE_NAMESPACE);
			$cache->remove(Countries::CACHE_NAMESPACE);
		} catch (\Exception $e) {
			$this->em->rollback();
			$form->addError($e->getMessage());
			$this->redrawControl('form');

			return false;
		}
		$this->redrawControl('form');

		return false;
	}

	public function setCountry(string $id): void
	{
		$this->country = $this->countriesService->get($id);

		if ($this->country) {
			$o = $this->country;

			/** @var TextInput $id */
			$id = $this['form']->getComponent('id');
			$id->setDisabled(true);

			$this['form']->setDefaults([
				'name'      => $o->getName(),
				'id'        => $o->getId(),
				'iso3166_1' => $o->getIso3166_1(),
			]);
		} else {
			$this->presenter->error();
		}
	}
}
