<?php declare(strict_types = 1);

namespace Core\AdminModule\Components\Country;

use Core\Model\UI\BaseControl;
use Core\Model\Countries;
use Core\Model\UI\DataGrid\BaseDataGrid;

class CountryGrid extends BaseControl
{
	protected Countries $countriesService;

	public function __construct(
		Countries $countries
	)
	{
		$this->countriesService = $countries;
	}

	public function render(): void
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentGrid(): BaseDataGrid
	{
		$grid = $this->createGrid();

		$qb = $this->countriesService->getEr()
			->createQueryBuilder('p')
			->orderBy('p.position', 'ASC');

		$grid->setDataSource($qb);

		$grid->setSortable();
		$grid->setSortableHandler('countryGrid:gridSortableRow!');

		//Columns
		$grid->addColumnText('id', 'default.id');
		$grid->addColumnLink('name', 'default.name', 'Country:editCountry');

		// Actions
		$grid->addAction('edit', '', 'Country:editCountry')
			->setIcon('edit')
			->setBsType('primary');
		$grid->addAction('delete', '', 'delete!')
			->setConfirm('default.reallyDelete')
			->setIcon('times')
			->setBsType('danger')
			->addClass('ajax');


		return $grid;
	}

	/*******************************************************************************************************************
	 * ==================  Handle
	 */

	public function handleDelete(string $id): void
	{
		if ($this->countriesService->remove($id)) {
			$this->presenter->flashMessageSuccess('default.removed');
		} else {
			$this->presenter->flashMessageDanger('default.removeFailed');
		}

		$this['grid']->reload();
		$this->presenter->redrawControl('flashes');
	}

	/*******************************************************************************************************************
	 * =================  Grid function
	 */

	public function handleGridSortableRow(): void
	{
		$request  = $this->presenter->getHttpRequest();
		$id       = $request->getPost('id');
		$position = $request->getPost('position');

		if ($id !== null && $position !== null && $this->countriesService->setPosition((string) $id, (int) $position)) {
			$this->presenter->flashMessageSuccess('default.positionChanged');
		} else {
			$this->presenter->flashMessageDanger('default.positionChangeFailed');
		}

		$this->presenter->redrawControl('flashes');
		$this->presenter->redrawControl('countryGrid');
	}

}
