<?php declare(strict_types = 1);

namespace Core\Components\Flashes;

use Core\Model\Http\Session;
use Core\Model\UI\BaseControl;
use Nette;

class Flashes extends BaseControl
{
	const FLASH_PRIMARY   = 'primary';
	const FLASH_SECONDARY = 'secondary';
	const FLASH_SUCCESS   = 'success';
	const FLASH_DANGER    = 'danger';
	const FLASH_WARNING   = 'warning';
	const FLASH_INFO      = 'info';

	protected static array $newFlashes = [];

	protected Session $session;

	public function __construct(Session $session)
	{
		$this->session = $session;
	}

	public function render(array $parameters = null): void
	{
		if ($parameters) {
			$this->template->parameters = Nette\Utils\ArrayHash::from($parameters);
		}

		$presenter = $this->presenter;

		foreach (self::$newFlashes as $k => $v) {
			$presenter->flashMessage($v['message'], $v['type']);
			unset(self::$newFlashes[$k]);
		}

		$flashes = $presenter->getTemplate()->flashes;

		if ($this->session->isStarted() && $presenter->hasFlashSession()) {
			$flashSession = $presenter->getFlashSession();
			$flashSession->setExpiration('1 minute');
			$flashes = $flashSession->flash;
		}

		$this->template->flashes = $flashes ?? [];
		$this->template->render($this->getTemplateFile());
	}

	/**
	 * @param string|\stdClass|Nette\HtmlStringable $message
	 * @param string                                $type
	 *
	 * @return void
	 */
	public static function addFlashMessage($message, string $type): void
	{
		self::$newFlashes[] = [
			'message' => $message,
			'type'    => $type,
		];
	}

	public static function hasNewFlashes(): bool { return (bool) count(self::$newFlashes); }
}
