<?php declare(strict_types = 1);

namespace Core\Components\Header;

use Core\Model\UI\BaseControl;

class Header extends BaseControl
{
	protected ?string $title       = null;
	protected ?string $description = null;
	protected ?string $icon        = null;

	public function render(): void
	{
		$this->template->title       = $this->title;
		$this->template->description = $this->description;
		$this->template->icon        = $this->icon;

		$this->template->render(__DIR__ . '/Header.latte');
	}

	public function setHeader(?string $icon, ?string $title, ?string $description): void
	{
		$this->icon        = $icon;
		$this->title       = $title;
		$this->description = $description;
	}

	public function getTitle(): ?string { return $this->title; }

	public function setTitle(?string $title): void { $this->title = $title; }

	public function getDescription(): ?string { return $this->description; }

	public function setDescription(?string $description): void { $this->description = $description; }

	public function getIcon(): ?string { return $this->icon; }

	public function setIcon(?string $icon): void { $this->icon = $icon; }
}
