<?php declare(strict_types = 1);

namespace Core\Components\Header;

use Core\FrontModule\Model\SeoParser;
use Core\Model\UI\BaseControl;

class Meta extends BaseControl
{
	protected SeoParser $seoParserService;

	protected array $metas        = [];
	protected array $otherHeaders = [];

	public function __construct(
		SeoParser $seoParser
	)
	{
		$this->seoParserService = $seoParser;
	}

	public function render(): void
	{
		$metas = $this->getMeta();

		if (isset($metas['canonical'])) {
			$canonical = $metas['canonical']['value'] === 'self'
				? $this->presenter->link('//this')
				: $metas['canonical']['value'];
			unset($metas['canonical']);
		} else {
			$canonical = $this->presenter->link('//this');
		}

		$this->template->canonical    = $canonical;
		$this->template->metas        = $metas;
		$this->template->otherHeaders = $this->otherHeaders;

		$this->template->render(__DIR__ . '/Meta.latte');
	}

	/*******************************************************************************************************************
	 * ======================== GET
	 */

	/**
	 * @return array|string
	 */
	public function getMeta(?string $key = null)
	{
		$metas = $this->metas;

		if ($key) {
			$metas = $metas[$key] ?? [];
		}

		return $key && isset($metas[$key]) ? $metas[$key] : $metas;
	}

	/*******************************************************************************************************************
	 * ======================== SET
	 */

	public function setMeta(string $key, string $value, string $attribute = 'name'): self
	{
		$this->metas[$key] = [
			'key'       => $key,
			'value'     => $this->seoParserService->parse($value),
			'attribute' => $attribute,
		];

		return $this;
	}

	public function setOtherHeader(string $string): self
	{
		$this->otherHeaders[] = $string;

		return $this;
	}
}
