<?php declare(strict_types = 1);

namespace Core\FrontModule\Model;

class Search
{
	protected SearchItemsCollection $searchItemsCollection;

	public function __construct(
		SearchItemsCollection $searchItemsCollection
	)
	{
		$this->searchItemsCollection = $searchItemsCollection;
	}

	public function search(string $q): array
	{
		$result = [];

		foreach ($this->searchItemsCollection->getItems() as $k => $item) {
			foreach ($item->search($q) as $item2) {
				$result[$item2->group][] = $item2;
			}
		}

		return $result;
	}
}
