<?php declare(strict_types = 1);

namespace Core\FrontModule\Presenters;

use Core\Model\Event\RobotsTxtEvent;
use Core\Model\Sites;
use Core\Model\SystemConfig;

class RobotsPresenter extends BasePresenter
{
	protected Sites $sites;

	public function __construct(
		Sites $sites
	)
	{
		$this->sites = $sites;
	}

	public function actionDefault(): void
	{
		$content = "User-agent: *\n" .
			"Disallow: /admin\n" .
			"Disallow: /assets/admin\n" .
			"Disallow: /assets/admin2\n" .
			"Disallow: /trafficbot.life\n";

		$content .= "\n";

		$currentSite = $this->sites->getCurrentSite();

		if (SystemConfig::load('autoGenerateSitemap')) {
			foreach ($currentSite->getDomains() as $domain) {
				$content .= "Sitemap: " . $this->getHttpRequest()->getUrl()->baseUrl . "sitemap-{$currentSite->getIdent()}-default-{$domain->getLang()}.xml\n";
			}
		} else {
			foreach ($currentSite->getDomains() as $domain) {
				foreach (glob(WWW_DIR . "/sitemap-{$currentSite->getIdent()}-*-{$domain->getLang()}.xml") ?: [] as $file) {
					$content .= "Sitemap: " . str_replace(WWW_DIR . '/', $this->getHttpRequest()->getUrl()->baseUrl, $file) . "\n";
				}
			}
		}

		$this->eventDispatcher->dispatch(new RobotsTxtEvent($content), 'core.generateRobotsTxt');

		header("Content-Type: text/plain");
		echo $content;
		exit;
	}
}
