<?php declare(strict_types = 1);

namespace Core\Model;

abstract class Config
{
	protected static array  $params;
	protected static string $separator = '.';

	public function __construct(?array $params)
	{
		self::$params[get_called_class()] = $params ?: [];
	}

	public static function setParams(array $params): void
	{
		self::$params[get_called_class()] = $params;
	}

	/**
	 * @param string $key
	 * @param mixed  $value
	 */
	public static function setParam($key, $value): void
	{
		$keys = explode(self::$separator, $key) ?: [];
		$key  = array_pop($keys);

		$arr = &self::$params[get_called_class()];
		foreach ($keys as $k) {
			if (!isset($arr[$k])) {
				break;
			}

			$arr = &$arr[$k];
		}

		if (isset($arr[$key])) {
			$arr[$key] = $value;
		}
	}

	public static function addParams(array $params): void
	{
		foreach ($params as $k => $v) {
			$keys    = explode(self::$separator, $k) ?: [];
			$arr     = &self::$params[get_called_class()];
			$lastKey = array_pop($keys);

			foreach ($keys as $key) {
				if (!isset($arr[$key])) {
					break;
				}

				$arr = &$arr[$key];
			}

			$arr[$lastKey] = $v;
		}
	}

	/**
	 * @param string $key
	 * @param mixed  $default
	 *
	 * @return mixed|null
	 */
	public function get($key, $default = null)
	{
		return self::load($key, $default);
	}

	/**
	 * @param mixed $default
	 *
	 * @return array|mixed|null
	 */
	public static function load(string $key, $default = null)
	{
		$keys = explode(self::$separator, $key) ?: [];
		$arr  = self::$params[get_called_class()] ?? [];

		foreach ($keys as $key) {
			if (!isset($arr[$key])) {
				return $default;
			}

			$arr = $arr[$key];
		}

		return $arr ?? $default;
	}

	public static function getTemplate(string $file): string
	{
		return APP_DIR . static::load('layouts.frontTemplatesPath') . DS . static::load('layouts.' . $file, $file . '.latte');
	}
}
