<?php declare(strict_types = 1);

namespace Core\Model\Dao;

use Nette\SmartObject;

/**
 * @property-read string|null $logo
 * @property-read string|null $inverseLogo
 * @property-read string|null $siteName
 * @property-read string|null $siteNameSeparator
 */
class Site
{
	use SmartObject;

	/** @var string */
	protected $ident;

	/** @var string */
	public $email;

	/** @var SiteDomain */
	protected $defaultDomain;

	/** @var SiteDomain[] */
	protected $domains = [];

	/** @var string */
	public $currentLang = 'cs';

	/**
	 * Site constructor.
	 *
	 * @param string $ident
	 */
	public function __construct(string $ident)
	{
		$this->ident = $ident;
	}

	public function getIdent(): string { return $this->ident; }

	/**
	 * @return SiteDomain[]
	 */
	public function getDomains(): array { return $this->domains; }

	public function addDomain(SiteDomain &$domain, int $isDefault = 0): self
	{
		$this->domains[$domain->getLang()] = &$domain;

		if ($isDefault)
			$this->defaultDomain = &$this->domains[$domain->getLang()];

		return $this;
	}

	public function removeDomain(string $key): self
	{
		unset($this->domains[$key]);

		return $this;
	}

	public function getDefaultDomain(): ?SiteDomain { return $this->defaultDomain; }

	public function getCurrentDomain(): ?SiteDomain { return $this->domains[$this->currentLang] ?? $this->defaultDomain; }

	public function getSiteName(): ?string { return $this->getCurrentDomain()->siteName; }

	public function getSiteNameSeparator(): ?string { return $this->getCurrentDomain()->siteNameSeparator; }

	public function getEmail(): ?string { return $this->email; }

	public function getLogo(): ?string { return $this->getCurrentDomain() ? $this->getCurrentDomain()->logo : null; }

	public function getInverseLogo(): ?string { return $this->getCurrentDomain() ? $this->getCurrentDomain()->inverseLogo : null; }
}
