<?php declare(strict_types = 1);

namespace Core\Model\Dbal\Driver;

use Core\Model\Helpers\DatabaseConfig;
use Core\Model\Helpers\Strings;
use Doctrine\DBAL\Driver\Mysqli\Connection;
use Doctrine\DBAL\Driver\Mysqli\Driver;
use Doctrine\DBAL\Driver\Mysqli\MysqliException;
use Doctrine\DBAL\Exception;

class Mysqli extends Driver
{
	public function connect(array $params, $username = null, $password = null, array $driverOptions = [])
	{
		try {
			return new Connection($params, (string) $username, (string) $password, $driverOptions);
		} catch (MysqliException $e) {
			$backupConnection = DatabaseConfig::$config[DatabaseConfig::getConfigKey()]['backupConnection'] ?? null;
			if ($backupConnection && Strings::contains($e->getMessage(), 'max_user_connections')) {
				try {
					$params['dsn'] = DatabaseConfig::getDsn($backupConnection['dbname'], $backupConnection['host']);

					return new Connection($params, (string) $backupConnection['user'], (string) $backupConnection['password'], $driverOptions);
				} catch (MysqliException $e) {
					throw Exception::driverException($this, $e);
				}
			}

			throw Exception::driverException($this, $e);
		}
	}
}
