<?php declare(strict_types = 1);

namespace Core\Model\Entities;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="core__extra_field", indexes={@ORM\Index(name="cef_base", columns={"section_name", "key"})})
 * @ORM\Entity
 */
class ExtraField
{
	use TId;

	/**
	 * @ORM\Column(name="section_name", type="string", length=255, nullable=false)
	 */
	public ?string $sectionName = null;

	/**
	 * @ORM\Column(name="section_key", type="string", length=255, nullable=false)
	 */
	public ?string $sectionKey = null;

	/**
	 * @ORM\Column(name="`key`", type="string", length=255, nullable=false)
	 */
	public string $key;

	/**
	 * @ORM\Column(name="value", type="text", nullable=true)
	 */
	public ?string $value = null;

	/**
	 * @ORM\Column(name="lang", type="string", length=2, nullable=true)
	 */
	public ?string $lang = null;

	public function __construct(string $key, ?string $value = null)
	{
		$this->key   = $key;
		$this->value = $value;
	}
}
