<?php declare(strict_types = 1);

namespace Core\Model\Entities;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="core__file_request")
 * @ORM\Entity
 */
class FileRequest
{
	use TId;

	/**
	 * @ORM\Column(name="data", type="text", nullable=false)
	 */
	protected string $data;

	public function __construct(string $data)
	{
		$this->data = $data;
	}

	public function getData(): string { return $this->data; }
}
