<?php declare(strict_types = 1);

namespace Core\Model\Entities;

use Doctrine\Migrations\Finder\MigrationFinder as IMigrationFinder;
use Nettrine\Migrations\ContainerAwareConfiguration;

class MigrationsContainerAwareConfiguration extends ContainerAwareConfiguration
{
	/** @var MigrationFinder */
	protected $myMigrationFinder;

	public function getMigrationsFinder(): IMigrationFinder
	{
		if ($this->myMigrationFinder === null)
			$this->myMigrationFinder = new MigrationFinder();

		return $this->myMigrationFinder;
	}
}
