<?php declare(strict_types = 1);

namespace Core\Model\Helpers;

class Ares
{
	public function findByIco(string $ico): ?array
	{
		$file = @file_get_contents('http://wwwinfo.mfcr.cz/cgi-bin/ares/darv_bas.cgi?ico=' . $ico);
		$xml  = $file ? @simplexml_load_string($file) : null;

		if ($xml) {
			$ns = $xml->getDocNamespaces();
			if (!$ns) {
				return null;
			}

			$data = $xml->children($ns['are']);
			if (!$data) {
				return null;
			}

			$el = $data->children($ns['D'])->VBAS;

			if (strval($el->ICO) == $ico) {
				$cp     = strval($el->AA->CO) ? strval($el->AA->CD) . '/' . strval($el->AA->CO) : strval($el->AA->CD);
				$street = strval($el->AA->NU);
				$city   = strval($el->AA->N);

				return [
					'ico'     => strval($el->ICO),
					'dic'     => strval($el->DIC),
					'company' => strval($el->OF),
					'street'  => trim(($street ?: $city) . ' ' . $cp),
					'city'    => $city,
					'zip'     => strval($el->AA->PSC),
				];
			}
		}

		return null;
	}
}
