<?php declare(strict_types = 1);

namespace Core\Model\Helpers;

use Core\Model\Entities\EntityRepository;
use Core\Model\Entities\EntityManagerDecorator;

abstract class BaseEntityService extends BaseService
{
	/** @var EntityManagerDecorator @inject */
	public $em;

	/** @var EntityRepository|null */
	protected $er;

	/** @var string */
	protected $entityClass;

	/** @return EntityRepository */
	public function getEr()
	{
		if ($this->er === null) {
			/** @var EntityRepository $er */
			$er       = $this->em->getRepository($this->entityClass);
			$this->er = $er;
		}

		return $this->er;
	}

	/**
	 * @param int|string $id
	 *
	 * @return \Doctrine\ORM\Proxy\Proxy|null
	 */
	public function getReference($id)
	{
		return $this->em->getReference($this->entityClass, $id);
	}

	/**
	 * Vraci instanci entity podle primarniho klice s oznacením id
	 *
	 * @param int|string|array $id
	 *
	 * @return array|mixed|null|object
	 */
	public function get($id)
	{
		return is_array($id) ? $this->getEr()->findBy(['id' => $id]) : $this->getEr()->find($id);
	}

	/** @return array */
	public function getAll() { return $this->getEr()->findAll(); }

	/**
	 * @param int|string $id Některé entity mají klíč string
	 *
	 * @return bool
	 */
	public function remove($id)
	{
		if ($entity = $this->get($id)) {
			$this->em->remove($entity);
			$this->em->flush();

			return true;
		}

		return false;
	}

	public function removeMultiple(array $ids): bool
	{
		$entities = $this->get($ids);

		if (count($entities) !== count($ids)) {
			return false;
		}

		$this->em->beginTransaction();
		try {
			$result = Arrays::every($entities, function($entity, $k, $ids): bool {
				try {
					$this->em->remove($entity);

					return true;
				} catch (\Exception $e) {
				}

				return false;
			});

			if ($result) {
				$this->em->flush();
				$this->em->commit();
			} else {
				throw new \Exception('result false');
			}
		} catch (\Exception $e) {
			if ($this->em->getConnection()->isTransactionActive()) {
				$this->em->rollback();
			}

			$result = false;
		}

		return $result;
	}
}
